/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.imageprocess;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.error.AipError;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.http.EBodyFormat;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

public class AipImageProcess
extends BaseClient {
    public AipImageProcess(String appId, String apiKey, String secretKey) {
        super(appId, apiKey, secretKey);
    }

    public JSONObject imageQualityEnhance(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/image_quality_enhance");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject imageQualityEnhance(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.imageQualityEnhance(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject dehaze(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/dehaze");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject dehaze(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.dehaze(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject contrastEnhance(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/contrast_enhance");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject contrastEnhance(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.contrastEnhance(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject colourize(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/colourize");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject colourize(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.colourize(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject stretchRestore(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/stretch_restore");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject stretchRestore(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.stretchRestore(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject styleTrans(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.styleTrans(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject styleTrans(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/style_trans");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject inpaintingByMask(String image, List<JSONObject> list, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.inpaintingByMask(data, list, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject inpaintingByMask(byte[] image, List<JSONObject> list, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("rectangle", list);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/inpainting");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject imageDefinitionEnhance(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.imageDefinitionEnhance(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject imageDefinitionEnhance(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/image_definition_enhance");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject selfieAnime(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.selfieAnime(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject selfieAnime(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/selfie_anime");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject skySeg(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.skySeg(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject skySeg(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/sky_seg");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject colorEnhance(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.colorEnhance(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject colorEnhance(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/color_enhance");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject colorEnhanceUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/color_enhance");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject removeMoireV1(String imagePath, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(imagePath);
            return this.removeMoireV1(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject removeMoireV1(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/remove_moire");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject removeMoireV1Url(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/remove_moire");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject removeMoireV1Pdf(String pdfPath, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(pdfPath);
            return this.removeMoireV1Pdf(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject removeMoireV1Pdf(byte[] pdf, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(pdf);
        request.addBody("pdf_file", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/remove_moire");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject customizeStylizationV1(String imagePath, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(imagePath);
            return this.customizeStylizationV1(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject customizeStylizationV1(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/customize_stylization");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject customizeStylizationV1Url(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/customize_stylization");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject docRepairV1(String imagePath, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(imagePath);
            return this.docRepairV1(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject docRepairV1(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/doc_repair");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject docRepairV1Url(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/doc_repair");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject denoiseV1(String imagePath, int option) {
        try {
            byte[] data = Util.readFileByBytes(imagePath);
            return this.denoiseV1(data, option);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject denoiseV1(byte[] image, int option) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("option", option);
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/denoise");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject denoiseV1Url(String url, int option) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.addBody("option", option);
        request.setUri("https://aip.baidubce.com/rest/2.0/image-process/v1/denoise");
        this.postOperation(request);
        return this.requestServer(request);
    }
}

